
function onLoaded() {
    var csInterface = new CSInterface();
    updateThemeWithAppSkinInfo(csInterface.hostEnvironment.appSkinInfo);
    // Update the color of the panel when the theme color of the product changed.
    csInterface.addEventListener(CSInterface.THEME_COLOR_CHANGED_EVENT, onAppThemeColorChanged);


//    var lumButtonNames = ['CreateLuminosityMasks', 'DeleteLuminosityMasks', 'CreateBrightMasks', 'DeleteBrightMasks', 'CreateDarkMasks', 'DeleteDarkMasks', 'CreateMidtoneMasks', 'DeleteMidtoneMasks'];
//    lumButtonNames.forEach(function(name)
//        {
//            $("#"+name).click(function()
//                {
//                    csInterface.evalScript('$._ext.' + name.substr(0, 1).toLowerCase() + name.substring(1) +'()', function(msg) 
//                    {
//                        console.log('$._ext.' + name.substr(0, 1).toLowerCase() + name.substring(1) +'() : ' + msg);
//                    });
//                });
//        });

    var buttonNames = [{id: "CreateLuminosityMasks", script: "Create Luminosity Masks.js"}, 
                       {id: "DeleteLuminosityMasks", script: "Start Deleting.js"}, 
                       {id: "CreateBrightMasks",     script: "Create Bright Masks.js"}, 
                       {id: "DeleteBrightMasks",     script: "Delete Bright LMs.js"}, 
                       {id: "CreateDarkMasks",       script: "Create Dark LMs.js"}, 
                       {id: "DeleteDarkMasks",       script: "Delete Darks LMs.js"}, 
                       {id: "CreateMidtoneMasks",    script: "Create Midtone LMs.js"}, 
                       {id: "DeleteMidtoneMasks",    script: "Delete Midtone LMs.js"}, 
                       {id: "CreateOrtonEffect",     script: "Orton Effect 2.js"}, 
                       {id: "EnhanceDetails",        script: "Enahnce Details.js"}, 
                       {id: "AutumnColours",         script: "AutumnColours.jsx"}, 
                       {id: "SharpenFullSize",       script: "SharpenFullSize.jsx"}, 
                       {id: "SharpenForWeb",         script: "SharpenForWeb.jsx"}, 
                       {id: "DodgeBurnLayer",        script: "DodgeBurnLayer.jsx"}];

    buttonNames.forEach(function(button) 
        {
            $("#" + button.id).click(function()
            {
                loadJSX(button.script);
            });
        });
    
    $("#learnLink").click(function()
        {
            csInterface.openURLInDefaultBrowser('http://www.shutterevolve.com/raya-pro-the-ultimate-digital-blending-workflow-panel-for-photoshop/');
        });
}



/**
 * Update the theme with the AppSkinInfo retrieved from the host product.
 */
function updateThemeWithAppSkinInfo(appSkinInfo) {
	
    //Update the background color of the panel
    var panelBackgroundColor = appSkinInfo.panelBackgroundColor.color;
    document.body.bgColor = toHex(panelBackgroundColor);
        
    var styleId = "ppstyle";
    
    var csInterface = new CSInterface();
	var appName = csInterface.hostEnvironment.appName;
    
    if(appName == "PHXS"){
	    addRule(styleId, "button, select, input[type=button], input[type=submit]", "border-radius:3px;");
	}
	if(appName == "PHXS" || appName == "PPRO" || appName == "PRLD") {
		////////////////////////////////////////////////////////////////////////////////////////////////
		// NOTE: Below theme related code are only suitable for Photoshop.                            //
		// If you want to achieve same effect on other products please make your own changes here.    //
		////////////////////////////////////////////////////////////////////////////////////////////////
		
	    
	    var gradientBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, 40) + " , " + toHex(panelBackgroundColor, 10) + ");";
	    var gradientDisabledBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, 15) + " , " + toHex(panelBackgroundColor, 5) + ");";
	    var boxShadow = "-webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);";
	    var boxActiveShadow = "-webkit-box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.6);";
	    
	    var isPanelThemeLight = panelBackgroundColor.red > 127;
        var buttonBg;
        var buttonHoverBg;
	    var fontColor, disabledFontColor;
	    var borderColor;
	    var inputBackgroundColor;
	    var gradientHighlightBg;

	    if(isPanelThemeLight) {
            buttonBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, -40) + " , " + toHex(panelBackgroundColor, -70) + ");";
            buttonHoverBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, -10) + " , " + toHex(panelBackgroundColor, -40) + ");";
	    	fontColor = "#000000;";
            titleColor = toHex(panelBackgroundColor, -140) ;
            subtitleColor =toHex(panelBackgroundColor, -80) ;
	    	disabledFontColor = "color:" + toHex(panelBackgroundColor, -70) + ";";
	    	borderColor = "border-color: " + toHex(panelBackgroundColor, -90) + ";";
	    	inputBackgroundColor = toHex(panelBackgroundColor, 54) + ";";
	    	gradientHighlightBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, -40) + " , " + toHex(panelBackgroundColor,-50) + ");";
	    } else {
	    	fontColor = "#282828;";
            titleColor = toHex(panelBackgroundColor, 150) ;
            subtitleColor =toHex(panelBackgroundColor, 60) ;
            buttonBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, 150) + " , " + toHex(panelBackgroundColor, 80) + ");";
            buttonHoverBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, 200) + " , " + toHex(panelBackgroundColor, 120) + ");";
	    	disabledFontColor = "color:" + toHex(panelBackgroundColor, 100) + ";";
	    	borderColor = "border-color: " + toHex(panelBackgroundColor, -45) + ";";
	    	inputBackgroundColor = toHex(panelBackgroundColor, -20) + ";";
	    	gradientHighlightBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, -20) + " , " + toHex(panelBackgroundColor, -30) + ");";
	    }
	    
	
	    //Update the default text style with pp values
	    
	    addRule(styleId, "h1", "color:" + titleColor + "; ");
	    addRule(styleId, "h3", "font-size:" + 16 + "px" + "; color:" + subtitleColor + "; ");
	    addRule(styleId, ".default", "font-size:" + appSkinInfo.baseFontSize + "px" + "; color:" + fontColor + "; background-color:" + toHex(panelBackgroundColor) + ";");
	    addRule(styleId, "button, select, input[type=text], input[type=button], input[type=submit]", borderColor);    
	    addRule(styleId, "select, input[type=button], input[type=submit]", gradientBg);    
	    addRule(styleId, "button", buttonBg);    
	    addRule(styleId, "button:hover", buttonHoverBg);    
	    addRule(styleId, "button, select, input[type=button], input[type=submit]", boxShadow);
	    addRule(styleId, "button:enabled:active, input[type=button]:enabled:active, input[type=submit]:enabled:active", gradientHighlightBg);
	    addRule(styleId, "button:enabled:active, input[type=button]:enabled:active, input[type=submit]:enabled:active", boxActiveShadow);
	    addRule(styleId, "[disabled]", gradientDisabledBg);
	    addRule(styleId, "[disabled]", disabledFontColor);
	    addRule(styleId, "input[type=text]", "padding:1px 3px;");
	    addRule(styleId, "input[type=text]", "background-color: " + inputBackgroundColor) + ";";
	    addRule(styleId, "input[type=text]:focus", "background-color: #ffffff;");
	    addRule(styleId, "input[type=text]:focus", "color: #000000;");
	    
	} else {
		// For AI, ID and FL use old implementation	
		addRule(styleId, ".default", "font-size:" + appSkinInfo.baseFontSize + "px" + "; color:" + reverseColor(panelBackgroundColor) + "; background-color:" + toHex(panelBackgroundColor, 20));
	    addRule(styleId, "button", "border-color: " + toHex(panelBgColor, -50));
	}
}

function addRule(stylesheetId, selector, rule) {
    var stylesheet = document.getElementById(stylesheetId);
    
    if (stylesheet) {
        stylesheet = stylesheet.sheet;
           if( stylesheet.addRule ){
               stylesheet.addRule(selector, rule);
           } else if( stylesheet.insertRule ){
               stylesheet.insertRule(selector + ' { ' + rule + ' }', stylesheet.cssRules.length);
           }
    }
}


function reverseColor(color, delta) {
    return toHex({red:Math.abs(255-color.red), green:Math.abs(255-color.green), blue:Math.abs(255-color.blue)}, delta);
}

/**
 * Convert the Color object to string in hexadecimal format;
 */
function toHex(color, delta) {
    function computeValue(value, delta) {
        var computedValue = !isNaN(delta) ? value + delta : value;
        if (computedValue < 0) {
            computedValue = 0;
        } else if (computedValue > 255) {
            computedValue = 255;
        }

        computedValue = computedValue.toString(16);
        return computedValue.length == 1 ? "0" + computedValue : computedValue;
    }

    var hex = "";
    if (color) {
        with (color) {
             hex = computeValue(red, delta) + computeValue(green, delta) + computeValue(blue, delta);
        };
    }
    return "#" + hex;
}

function onAppThemeColorChanged(event) {
    // Should get a latest HostEnvironment object from application.
    var skinInfo = JSON.parse(window.__adobe_cep__.getHostEnvironment()).appSkinInfo;
    // Gets the style information such as color info from the skinInfo, 
    // and redraw all UI controls of your extension according to the style info.
    updateThemeWithAppSkinInfo(skinInfo);
} 



    
/**
 * Load JSX file into the scripting context of the product. All the jsx files in 
 * folder [ExtensionRoot]/jsx will be loaded. 
 */
function loadJSX(filename) {
    var csInterface = new CSInterface();
    var extensionRoot = csInterface.getSystemPath(SystemPath.EXTENSION) + "/jsx/";
    console.log('$._ext.evalFile("' + extensionRoot + filename+'")')
    csInterface.evalScript('$._ext.evalFile("' + extensionRoot + filename+'")', function(msg) 
    {
        console.log(msg);
    });
}

function evalScript(script, callback) {
    new CSInterface().evalScript(script, callback);
}

